IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('[dbo].[P_EST_PED_CP_CLONE]') AND type in ('P', 'PC'))
DROP PROCEDURE [dbo].[P_EST_PED_CP_CLONE]
GO 
GO 

--P_EST_PED_CP_CLONE 3923,900,90
CREATE PROCEDURE P_EST_PED_CP_CLONE (@CD_PED INT, @CD_FIL_ORIG INT,@CD_FIL_DEST INT,@CANCELA tinyint=1)
--WITH ENCRYPTION 
AS

	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION  LEVEL READ UNCOMMITTED ;

	DECLARE @CD_PED_NOVO INT;

	SET @CD_PED_NOVO =ISNULL((SELECT MAX(CD_PED)FROM EST_PED_CP WITH (NOLOCK)
								WHERE CD_FILIAL =@CD_FIL_DEST
								AND CD_EMP=1),0)+1;
	Print 'Gerando o pedido ' + convert(varchar(10), @CD_PED_NOVO) + ' na filial ' + convert(varchar(10), @CD_FIL_DEST);

begin try
	INSERT INTO EST_PED_CP(CD_EMP,CD_FILIAL,CD_PED,CD_FORN,DT_EMI,VLR_PED,VLR_TOT_PROD,VLR_DESC,DT_PREV_ENT,VLR_ENCG_FIN,
								PERC_ICMS_ENCG_FIN,VLR_ICMS,VLR_IPI,VLR_BASE_SUBS,VLR_ICMS_SUBS,
								CD_NT_MOV,STS_PED,VLR_BASE_ICMS,CD_USU,DT_CAD,
								DT_ULT_ATU,DT_BAIXA,VLR_FRETE,NF_IPI_BASE_CALC,ENCG_TRIB,
								NAO_CONSTAR_PEND_ENTR,DT_CANCEL,CD_USU_CANCEL,
								NR_REQ_FORN,TP_FRETE,CONHECIMENTO,CALC_SUBS_PMC,PERC_REDU_SUBS_PMC,DT_PREV_ENT_ANT,
								CD_PED_FORN,CD_TIPO_FATURAMENTO,HORA_PREV_ENT,QT_VOL,FLAG_GERAR_CROSS,CD_COND_PGTO,CD_CTR_DANFE,
								ORIGEM_PED,APLICATIVO,VERSAO_APLICATIVO,DT_FATURAMENTO)
	SELECT 
		P.CD_EMP,
		@CD_FIL_DEST CD_FILIAL,
		@CD_PED_NOVO CD_PED,
		CD_FORN,
		CONVERT(DATE, GETDATE()) DT_EMI,
		VLR_PED,
		VLR_TOT_PROD,
		VLR_DESC,
		DATEADD(day, DATEDIFF(DAY,DT_EMI,DT_PREV_ENT),getdate()),
		VLR_ENCG_FIN,
		PERC_ICMS_ENCG_FIN,
		VLR_ICMS,
		VLR_IPI,
		VLR_BASE_SUBS,
		VLR_ICMS_SUBS,
		CD_NT_MOV,
		0 STS_PED,
		VLR_BASE_ICMS,
		CD_USU,
		GETDATE() DT_CAD,
		NULL DT_ULT_ATU,
		DT_BAIXA,
		VLR_FRETE,
		NF_IPI_BASE_CALC,
		ENCG_TRIB,
		NAO_CONSTAR_PEND_ENTR,
		DT_CANCEL,
		CD_USU_CANCEL,
		NR_REQ_FORN,
		TP_FRETE,
		CONHECIMENTO,
		CALC_SUBS_PMC,
		PERC_REDU_SUBS_PMC,
		DT_PREV_ENT_ANT,
		CD_PED_FORN,
		CD_TIPO_FATURAMENTO,
		HORA_PREV_ENT,
		QT_VOL,
		FLAG_GERAR_CROSS,
		CD_COND_PGTO,
		CD_CTR_DANFE,
		ORIGEM_PED,
		'ORIG_PED_CLONE' APLICATIVO,
		VERSAO_APLICATIVO,
		DT_FATURAMENTO 
	FROM
		EST_PED_CP P
	WHERE
		P.CD_EMP=1
		AND P.CD_PED	= @CD_PED 
		AND P.CD_FILIAL = @CD_FIL_ORIG;

	INSERT INTO EST_PED_CP_IT (CD_EMP, CD_FILIAL, CD_PED, CD_PROD, SEQ_ITEM, VLR_IT, QT_IT, 
								CD_TRIB, PERC_IPI, VLR_CUSTO, VLR_BASE_SUBS, 
								VLR_ICMS_SUBS, ALIQ_ICMS, VLR_BASE_ICMS, CD_NT_OP, VLR_IPI, VLR_ICMS, 
								PERC_DESC, VLR_DESC, PERC_IVA, QT_EMB, PERC_IPI_CUSTO, 
								PERC_DESC_FINAN, CD_COND_COMPRA)
	SELECT
		I.CD_EMP, 
		@CD_FIL_DEST CD_FILIAL,
		@CD_PED_NOVO CD_PED,
		I.CD_PROD, 
		I.SEQ_ITEM,  
		I.VLR_IT, 
		I.QT_IT,
		I.CD_TRIB, 
		I.PERC_IPI, 
		I.VLR_CUSTO, 
		I.VLR_BASE_SUBS, 
		I.VLR_ICMS_SUBS, 
		I.ALIQ_ICMS, 
		I.VLR_BASE_ICMS, 
		I.CD_NT_OP, 
		I.VLR_IPI, 
		I.VLR_ICMS, 
		I.PERC_DESC,  
		I.VLR_DESC, 
		I.PERC_IVA, 
		I.QT_EMB,  
		I.PERC_IPI_CUSTO, 
		I.PERC_DESC_FINAN, 
		I.CD_COND_COMPRA
	FROM 
		EST_PED_CP_IT I  
	WHERE
		i.CD_EMP=1
		AND i.CD_PED	= @CD_PED 
		AND i.CD_FILIAL = @CD_FIL_ORIG;


	IF @CANCELA =1
	BEGIN

		print 'Cancela o saldo gerado pelo novo pedido ' + convert(varchar,getdate(),108);
		--CANCELA O SALDO GERADO PELO NOVO PEDIDO
		INSERT INTO EST_PED_CP_IT_CANCEL_SLD (CD_EMP,CD_FILIAL,CD_PED,CD_PROD,CD_USU,QT_PROD,DT_CANCEL)
		SELECT
			I.CD_EMP,
			I.CD_FILIAL,
			I.CD_PED,
			I.CD_PROD,
			1 CD_USU, 
			(I.QT_IT* i.QT_EMB)   QT_PROD,
			GETDATE() DT_CANCEL
		FROM 
			EST_PED_CP_IT I 
			left join EST_PED_CP_IT_CANCEL_SLD s on 
			I.CD_EMP	 = s.CD_EMP		AND
			I.CD_FILIAL  = s.CD_FILIAL	AND
			I.CD_PED	 = S.CD_PED AND
			I.CD_PROD	 = S.CD_PROD
		WHERE
			S.CD_EMP IS NULL
			AND i.CD_EMP=1
			AND i.CD_PED	= @CD_PED 
			AND i.CD_FILIAL = @CD_FIL_ORIG;
	END 
END TRY
BEGIN CATCH
	Print 'Falha ao tentar criar/vincular pedido de compras'
	PRINT ERROR_MESSAGE() 
	return;
END CATCH